USE [SQLSpreads_ForecastDemo2025]
GO
/****** Object:  Table [dbo].[dim_Account]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[dim_Account](
	[AccountKey] [int] IDENTITY(1,1) NOT NULL,
	[Account] [int] NOT NULL,
	[AccountName] [nvarchar](max) NOT NULL,
	[AccountGroup] [int] NOT NULL,
	[AccountGroupName] [nvarchar](max) NOT NULL,
	[ModifiedBy] [nvarchar](max) NULL,
	[ModifiedOn] [datetime2](7) NULL,
	[CreatedBy] [nvarchar](max) NULL,
	[CreatedOn] [datetime2](7) NULL,
 CONSTRAINT [PK_dim_Account_CCCE] PRIMARY KEY CLUSTERED 
(
	[AccountKey] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[dim_Company]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[dim_Company](
	[CompanyKey] [int] IDENTITY(1,1) NOT NULL,
	[CompanyCode] [varchar](2) NOT NULL,
	[CompanyName] [varchar](50) NOT NULL,
	[ModifiedBy] [nvarchar](max) NULL,
	[ModifiedOn] [datetime2](7) NULL,
	[CreatedBy] [nvarchar](max) NULL,
	[CreatedOn] [datetime2](7) NULL,
 CONSTRAINT [PK_dim_Company_5E35] PRIMARY KEY CLUSTERED 
(
	[CompanyKey] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[dim_Region]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[dim_Region](
	[RegionKey] [int] IDENTITY(1,1) NOT NULL,
	[RegionCode] [nvarchar](2) NOT NULL,
	[RegionName] [nvarchar](50) NOT NULL,
	[ModifiedBy] [nvarchar](max) NULL,
	[ModifiedOn] [datetime2](7) NULL,
	[CreatedBy] [nvarchar](max) NULL,
	[CreatedOn] [datetime2](7) NULL,
 CONSTRAINT [PK_dim_Region_E44E] PRIMARY KEY CLUSTERED 
(
	[RegionKey] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[forecast_Access]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[forecast_Access](
	[ForecastAccessId] [int] IDENTITY(1,1) NOT NULL,
	[RegionKey] [int] NOT NULL,
	[CompanyKey] [int] NOT NULL,
	[UnitManager] [nvarchar](max) NOT NULL,
	[InterimUnitManager] [nvarchar](max) NOT NULL,
	[Approver] [nvarchar](max) NOT NULL,
	[ModifiedBy] [nvarchar](max) NOT NULL,
	[ModifiedOn] [datetime2](7) NOT NULL,
	[CreatedBy] [nvarchar](max) NOT NULL,
	[CreatedOn] [datetime2](7) NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[forecast_Version]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[forecast_Version](
	[ForecastVersionKey] [int] NOT NULL,
	[ForecastName] [nvarchar](max) NULL,
	[Open] [bit] NOT NULL,
	[Committed] [bit] NOT NULL,
	[ComittedBy] [nvarchar](max) NOT NULL,
	[Approved] [bit] NOT NULL,
	[ApprovedBy] [nvarchar](max) NOT NULL,
	[ModifiedBy] [nvarchar](max) NULL,
	[ModifiedOn] [datetime2](7) NULL,
	[CreatedBy] [nvarchar](max) NULL,
	[CreatedOn] [datetime2](7) NULL,
 CONSTRAINT [PK_forecast_Version_BE5C] PRIMARY KEY CLUSTERED 
(
	[ForecastVersionKey] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[forecast_Workflow]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[forecast_Workflow](
	[ForecastWorkflowKey] [int] IDENTITY(1,1) NOT NULL,
	[ForecastVersionKey] [int] NULL,
	[RegionKey] [int] NULL,
	[CompanyKey] [int] NULL,
	[Committed] [bit] NULL,
	[CommittedBy] [nvarchar](max) NULL,
	[CommittedOn] [datetime2](7) NULL,
	[Approved] [bit] NULL,
	[ApprovedBy] [nvarchar](max) NULL,
	[ApprovedOn] [datetime2](7) NULL,
	[ModifiedBy] [nvarchar](max) NULL,
	[ModifiedOn] [datetime2](7) NULL,
	[CreatedBy] [nvarchar](max) NULL,
	[CreatedOn] [datetime2](7) NULL,
 CONSTRAINT [PK_forecast_Workflow_4D63] PRIMARY KEY CLUSTERED 
(
	[ForecastWorkflowKey] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[forecastData]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[forecastData](
	[ForecastDataKey] [int] IDENTITY(1,1) NOT NULL,
	[ForecastVersionKey] [int] NULL,
	[RegionKey] [int] NOT NULL,
	[CompanyKey] [int] NOT NULL,
	[AccountKey] [int] NOT NULL,
	[DateKey] [int] NULL,
	[Amount] [money] NOT NULL,
	[Comment] [nvarchar](max) NULL,
	[ModifiedBy] [nvarchar](max) NOT NULL,
	[ModifiedOn] [datetime2](7) NOT NULL,
	[CreatedBy] [nvarchar](max) NOT NULL,
	[CreatedOn] [datetime2](7) NOT NULL,
 CONSTRAINT [PK_forecastData_ED8E] PRIMARY KEY CLUSTERED 
(
	[ForecastDataKey] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[dim_Account] ON 
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (1, 6000, N'Salaries', 600, N'Labor Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (2, 6020, N'Payroll Taxes', 600, N'Labor Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (3, 6040, N'Employee Benefits', 600, N'Labor Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (4, 6100, N'Commissions', 60, N'Operating Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (5, 6200, N'Travel Transportation', 620, N'Travel Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (6, 6210, N'Travel Lodging', 620, N'Travel Expenses', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-23T07:13:34.4590000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (7, 6220, N'Meals', 620, N'Travel Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (8, 6230, N'Entertainment', 620, N'Travel Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (9, 6240, N'Other Travel Related', 620, N'Travel Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (10, 6300, N'Conferences', 630, N'Marketing', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (11, 6310, N'Marketing Collateral', 630, N'Marketing', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (12, 6400, N'Office Supplies', 60, N'Operating Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (13, 6500, N'Professional Services', 60, N'Operating Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (14, 6610, N'Telephone', 660, N'Telephone and Utilities', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (15, 6620, N'Utilities', 660, N'Telephone and Utilities', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (16, 6700, N'Other Expenses', 60, N'Operating Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Account] ([AccountKey], [Account], [AccountName], [AccountGroup], [AccountGroupName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (18, 6710, N'Vehicles', 60, N'Operating Expenses', N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2), N'', CAST(N'2025-01-01T10:00:00.0000000' AS DateTime2))
GO
SET IDENTITY_INSERT [dbo].[dim_Account] OFF
GO
SET IDENTITY_INSERT [dbo].[dim_Company] ON 
GO
INSERT [dbo].[dim_Company] ([CompanyKey], [CompanyCode], [CompanyName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (1, N'AR', N'Arbicorn', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-23T07:20:21.7720000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-01-01T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Company] ([CompanyKey], [CompanyCode], [CompanyName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (2, N'AU', N'AGECO', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T06:36:17.2360000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-01-01T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Company] ([CompanyKey], [CompanyCode], [CompanyName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (3, N'EL', N'Elite Products', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-10-24T06:33:59.3450000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-01-01T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Company] ([CompanyKey], [CompanyCode], [CompanyName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (6, N'TI', N'Trifo AB', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-23T07:19:36.1420000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2021-10-28T13:16:35.0100000' AS DateTime2))
GO
SET IDENTITY_INSERT [dbo].[dim_Company] OFF
GO
SET IDENTITY_INSERT [dbo].[dim_Region] ON 
GO
INSERT [dbo].[dim_Region] ([RegionKey], [RegionCode], [RegionName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (1, N'CA', N'California', N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-03-06T16:29:26.0000000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-01-01T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Region] ([RegionKey], [RegionCode], [RegionName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (2, N'IL', N'Illinois', N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-03-06T16:29:26.0000000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-01-01T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Region] ([RegionKey], [RegionCode], [RegionName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (3, N'MN', N'Minnesota', N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-03-06T16:29:26.0000000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-01-01T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Region] ([RegionKey], [RegionCode], [RegionName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (4, N'AL', N'Alabama', N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-03-06T16:29:26.0000000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-01-01T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Region] ([RegionKey], [RegionCode], [RegionName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (5, N'ID', N'Idaho', N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-03-06T16:29:26.0000000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-01-01T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Region] ([RegionKey], [RegionCode], [RegionName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (6, N'MI', N'Michigan', N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-03-06T16:29:26.0000000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-01-01T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Region] ([RegionKey], [RegionCode], [RegionName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (7, N'TX', N'Texas', N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-03-06T16:29:26.0000000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-01-01T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[dim_Region] ([RegionKey], [RegionCode], [RegionName], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (8, N'WA', N'Washington', N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-03-06T16:29:26.0000000' AS DateTime2), N'LAPTOP-ATR1GRT3\JAK', CAST(N'2020-01-01T00:00:00.0000000' AS DateTime2))
GO
SET IDENTITY_INSERT [dbo].[dim_Region] OFF
GO
SET IDENTITY_INSERT [dbo].[forecast_Access] ON 
GO
INSERT [dbo].[forecast_Access] ([ForecastAccessId], [RegionKey], [CompanyKey], [UnitManager], [InterimUnitManager], [Approver], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (1, 1, 1, N'AzureAD\JohannesÅkesson', N'LAPTOP-JAK\Johannes Åkesson', N'obnex\WER', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-05-03T09:05:17.7820000' AS DateTime2), N'', CAST(N'2024-03-22T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[forecast_Access] ([ForecastAccessId], [RegionKey], [CompanyKey], [UnitManager], [InterimUnitManager], [Approver], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (2, 1, 2, N'AzureAD\JohannesÅkesson', N'LAPTOP-JAK\Johannes Åkesson', N'obnex\WER', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-05-03T09:05:17.7820000' AS DateTime2), N'', CAST(N'2024-03-22T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[forecast_Access] ([ForecastAccessId], [RegionKey], [CompanyKey], [UnitManager], [InterimUnitManager], [Approver], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (3, 7, 3, N'AzureAD\JohannesÅkesson', N'LAPTOP-JAK\Johannes Åkesson', N'obnex\WER', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-05-17T14:10:21.2410000' AS DateTime2), N'', CAST(N'2024-03-22T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[forecast_Access] ([ForecastAccessId], [RegionKey], [CompanyKey], [UnitManager], [InterimUnitManager], [Approver], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (4, 7, 1, N'AzureAD\JohannesÅkesson', N'LAPTOP-JAK\Johannes Åkesson', N'obnex\WER', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-05-17T14:10:21.2410000' AS DateTime2), N'', CAST(N'2024-03-22T00:00:00.0000000' AS DateTime2))
GO
INSERT [dbo].[forecast_Access] ([ForecastAccessId], [RegionKey], [CompanyKey], [UnitManager], [InterimUnitManager], [Approver], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (5, 7, 6, N'AzureAD\JohannesÅkesson', N'LAPTOP-JAK\Johannes Åkesson', N'obnex\WER', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-05-17T14:10:21.2410000' AS DateTime2), N'', CAST(N'2024-03-22T00:00:00.0000000' AS DateTime2))
GO
SET IDENTITY_INSERT [dbo].[forecast_Access] OFF
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202501, N'2025-Jan', 1, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202502, N'2025-Feb', 1, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202503, N'2025-Mar', 1, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-12-05T08:27:43.9630000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202504, N'2025-Apr', 1, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-12-05T08:27:43.9630000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202505, N'2025-May', 1, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202506, N'2025-June', 1, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T13:46:24.8260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202507, N'2025-July', 0, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202508, N'2025-Aug', 0, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202509, N'2025-Sep', 0, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202510, N'2025-Oct', 0, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202511, N'2025-Nov', 0, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-11-04T15:40:01.5590000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
INSERT [dbo].[forecast_Version] ([ForecastVersionKey], [ForecastName], [Open], [Committed], [ComittedBy], [Approved], [ApprovedBy], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (202512, N'2025-Dec', 0, 0, N'', 0, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-17T06:14:00.2700000' AS DateTime2))
GO
SET IDENTITY_INSERT [dbo].[forecast_Workflow] ON 
GO
INSERT [dbo].[forecast_Workflow] ([ForecastWorkflowKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [Committed], [CommittedBy], [CommittedOn], [Approved], [ApprovedBy], [ApprovedOn], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (75, 202501, 1, 2, 1, N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-10T12:00:11.2833333' AS DateTime2), 1, N'OBNEX/MJO', CAST(N'2025-01-10T16:00:11.0000000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-08-05T14:58:14.7510000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-15T18:15:43.0000000' AS DateTime2))
GO
INSERT [dbo].[forecast_Workflow] ([ForecastWorkflowKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [Committed], [CommittedBy], [CommittedOn], [Approved], [ApprovedBy], [ApprovedOn], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (76, 202501, 1, 1, 1, N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-10T17:19:41.3466667' AS DateTime2), 1, N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-11T08:19:41.0000000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-08-05T14:58:14.7510000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-15T18:15:43.0000000' AS DateTime2))
GO
INSERT [dbo].[forecast_Workflow] ([ForecastWorkflowKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [Committed], [CommittedBy], [CommittedOn], [Approved], [ApprovedBy], [ApprovedOn], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (77, 202501, 7, 1, 1, N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-01-12T15:43:23.0000000' AS DateTime2), 1, N'OBNEX/MJO', CAST(N'2025-01-12T18:43:23.0000000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-08-05T14:58:14.7510000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-15T18:15:43.0000000' AS DateTime2))
GO
INSERT [dbo].[forecast_Workflow] ([ForecastWorkflowKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [Committed], [CommittedBy], [CommittedOn], [Approved], [ApprovedBy], [ApprovedOn], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (78, 202501, 7, 3, 0, N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-12-05T08:30:15.5500000' AS DateTime2), 0, N'OBNEX/MJO', CAST(N'2025-01-11T09:12:00.0000000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-12-05T08:30:32.4010000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-15T18:15:43.0000000' AS DateTime2))
GO
INSERT [dbo].[forecast_Workflow] ([ForecastWorkflowKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [Committed], [CommittedBy], [CommittedOn], [Approved], [ApprovedBy], [ApprovedOn], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (79, 202501, 7, 6, 0, N'OBNEX/JAK', CAST(N'2025-01-15T16:10:00.0000000' AS DateTime2), 0, N'OBNEX/MJO', CAST(N'2025-01-16T17:48:00.0000000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-12-05T08:28:16.7140000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-15T18:15:43.0000000' AS DateTime2))
GO
SET IDENTITY_INSERT [dbo].[forecast_Workflow] OFF
GO
SET IDENTITY_INSERT [dbo].[forecastData] ON 
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21654, 202501, 1, 1, 1, 20250101, 3334.0000, N'', N'PreLoad,Actuals,251127', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21655, 202501, 1, 1, 1, 20250201, 3597.0000, N'', N'PreLoad,Actuals,251127', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21656, 202501, 1, 1, 1, 20250301, 2109.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21657, 202501, 1, 1, 1, 20250401, 1821.0000, N'', N'PreLoad,Actuals,251127', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21658, 202501, 1, 1, 1, 20250501, 2764.0000, N'', N'PreLoad,Actuals,251127', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21659, 202501, 1, 1, 1, 20250601, 2901.0000, N'', N'PreLoad,Actuals,251127', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21661, 202501, 1, 1, 1, 20250801, 1435.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21662, 202501, 1, 1, 1, 20250901, 3554.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21663, 202501, 1, 1, 1, 20251001, 2591.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21664, 202501, 1, 1, 1, 20251101, 2413.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21665, 202501, 1, 1, 1, 20251201, 3127.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21666, 202501, 1, 1, 5, 20250101, 1478.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21667, 202501, 1, 1, 5, 20250201, 2600.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21668, 202501, 1, 1, 5, 20250301, 2771.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21669, 202501, 1, 1, 5, 20250401, 3111.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21670, 202501, 1, 1, 5, 20250501, 3332.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21671, 202501, 1, 1, 5, 20250601, 2752.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21672, 202501, 1, 1, 5, 20250701, 2395.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21673, 202501, 1, 1, 5, 20250801, 2084.0000, N'', N'PreLoad,Forecst,2510', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21674, 202501, 1, 1, 5, 20250901, 1550.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21675, 202501, 1, 1, 5, 20251001, 1696.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21676, 202501, 1, 1, 5, 20251101, 2975.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21677, 202501, 1, 1, 5, 20251201, 1572.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21678, 202501, 1, 1, 6, 20250101, 1672.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21679, 202501, 1, 1, 6, 20250201, 3749.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21680, 202501, 1, 1, 6, 20250301, 2564.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21681, 202501, 1, 1, 6, 20250401, 1902.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21682, 202501, 1, 1, 6, 20250501, 3173.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21683, 202501, 1, 1, 6, 20250601, 2948.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21684, 202501, 1, 1, 6, 20250701, 2358.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21685, 202501, 1, 1, 6, 20250801, 2379.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21686, 202501, 1, 1, 6, 20250901, 3657.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21687, 202501, 1, 1, 6, 20251001, 2561.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21688, 202501, 1, 1, 6, 20251101, 3648.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21689, 202501, 1, 1, 6, 20251201, 1744.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:46.3170000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21690, 202501, 1, 1, 11, 20250101, 3021.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21691, 202501, 1, 1, 11, 20250201, 2190.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21692, 202501, 1, 1, 11, 20250301, 2116.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21693, 202501, 1, 1, 11, 20250401, 2210.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21694, 202501, 1, 1, 11, 20250501, 3250.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21695, 202501, 1, 1, 11, 20250601, 1775.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21696, 202501, 1, 1, 11, 20250701, 1979.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21697, 202501, 1, 1, 11, 20250801, 3071.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21698, 202501, 1, 1, 11, 20250901, 1528.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21699, 202501, 1, 1, 11, 20251001, 2550.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21700, 202501, 1, 1, 11, 20251101, 1925.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21701, 202501, 1, 1, 11, 20251201, 3742.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21702, 202501, 1, 1, 12, 20250101, 3139.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21703, 202501, 1, 1, 12, 20250201, 1586.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21704, 202501, 1, 1, 12, 20250301, 1583.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21705, 202501, 1, 1, 12, 20250401, 1983.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21706, 202501, 1, 1, 12, 20250501, 3691.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21707, 202501, 1, 1, 12, 20250601, 1695.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21708, 202501, 1, 1, 12, 20250701, 1611.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21709, 202501, 1, 1, 12, 20250801, 2512.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21710, 202501, 1, 1, 12, 20250901, 2717.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21711, 202501, 1, 1, 12, 20251001, 2385.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21712, 202501, 1, 1, 12, 20251101, 2823.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21713, 202501, 1, 1, 12, 20251201, 3702.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21714, 202501, 1, 1, 13, 20250101, 2413.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21715, 202501, 1, 1, 13, 20250201, 1598.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21716, 202501, 1, 1, 13, 20250301, 3564.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21717, 202501, 1, 1, 13, 20250401, 3534.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21718, 202501, 1, 1, 13, 20250501, 2321.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21719, 202501, 1, 1, 13, 20250601, 2584.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21720, 202501, 1, 1, 13, 20250701, 2798.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21721, 202501, 1, 1, 13, 20250801, 3744.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21722, 202501, 1, 1, 13, 20250901, 3453.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21723, 202501, 1, 1, 13, 20251001, 3154.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21724, 202501, 1, 1, 13, 20251101, 2464.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21725, 202501, 1, 1, 13, 20251201, 2320.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21726, 202501, 1, 1, 15, 20250101, 2087.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21727, 202501, 1, 1, 15, 20250201, 3018.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21728, 202501, 1, 1, 15, 20250301, 1703.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21729, 202501, 1, 1, 15, 20250401, 2967.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21730, 202501, 1, 1, 15, 20250501, 2709.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21731, 202501, 1, 1, 15, 20250601, 2414.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21732, 202501, 1, 1, 15, 20250701, 2360.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21733, 202501, 1, 1, 15, 20250801, 3174.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21734, 202501, 1, 1, 15, 20250901, 2277.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21735, 202501, 1, 1, 15, 20251001, 3147.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21736, 202501, 1, 1, 15, 20251101, 2670.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21737, 202501, 1, 1, 15, 20251201, 2777.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21738, 202501, 1, 1, 16, 20250101, 3595.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21739, 202501, 1, 1, 16, 20250201, 1478.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21740, 202501, 1, 1, 16, 20250301, 3038.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21741, 202501, 1, 1, 16, 20250401, 3574.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21742, 202501, 1, 1, 16, 20250501, 2821.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21743, 202501, 1, 1, 16, 20250601, 3458.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21744, 202501, 1, 1, 16, 20250701, 2471.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21745, 202501, 1, 1, 16, 20250801, 3697.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21746, 202501, 1, 1, 16, 20250901, 2847.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21747, 202501, 1, 1, 16, 20251001, 2407.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:57.2220000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21748, 202501, 1, 1, 16, 20251101, 3196.0000, N'', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-11-05T06:04:53.4080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21749, 202501, 1, 1, 16, 20251201, 1728.0000, N'', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-11-05T06:04:53.4080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21750, 202501, 1, 2, 1, 20250101, 1443.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21751, 202501, 1, 2, 1, 20250201, 2081.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21752, 202501, 1, 2, 1, 20250301, 1713.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21753, 202501, 1, 2, 1, 20250401, 2250.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21754, 202501, 1, 2, 1, 20250501, 1699.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21755, 202501, 1, 2, 1, 20250601, 2762.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21756, 202501, 1, 2, 1, 20250701, 3556.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21757, 202501, 1, 2, 1, 20250801, 2952.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21758, 202501, 1, 2, 1, 20250901, 3153.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21759, 202501, 1, 2, 1, 20251001, 2332.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21760, 202501, 1, 2, 1, 20251101, 2869.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21761, 202501, 1, 2, 1, 20251201, 2564.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21762, 202501, 1, 2, 5, 20250101, 2761.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21763, 202501, 1, 2, 5, 20250201, 2395.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21764, 202501, 1, 2, 5, 20250301, 3352.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21765, 202501, 1, 2, 5, 20250401, 2406.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21766, 202501, 1, 2, 5, 20250501, 3751.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21767, 202501, 1, 2, 5, 20250601, 2396.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21768, 202501, 1, 2, 5, 20250701, 2032.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21769, 202501, 1, 2, 5, 20250801, 3014.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21770, 202501, 1, 2, 5, 20250901, 1832.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21771, 202501, 1, 2, 5, 20251001, 3587.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21772, 202501, 1, 2, 5, 20251101, 2281.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21773, 202501, 1, 2, 5, 20251201, 1493.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21774, 202501, 1, 2, 6, 20250101, 2373.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21775, 202501, 1, 2, 6, 20250201, 1823.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21776, 202501, 1, 2, 6, 20250301, 1872.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21777, 202501, 1, 2, 6, 20250401, 1510.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21778, 202501, 1, 2, 6, 20250501, 1978.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21779, 202501, 1, 2, 6, 20250601, 1586.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21780, 202501, 1, 2, 6, 20250701, 2117.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21781, 202501, 1, 2, 6, 20250801, 1523.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21782, 202501, 1, 2, 6, 20250901, 3171.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21783, 202501, 1, 2, 6, 20251001, 3505.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21784, 202501, 1, 2, 6, 20251101, 3500.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21785, 202501, 1, 2, 6, 20251201, 2220.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21786, 202501, 1, 2, 11, 20250101, 2586.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21787, 202501, 1, 2, 11, 20250201, 1953.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21788, 202501, 1, 2, 11, 20250301, 1916.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21789, 202501, 1, 2, 11, 20250401, 3755.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21790, 202501, 1, 2, 11, 20250501, 1732.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21791, 202501, 1, 2, 11, 20250601, 2103.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21792, 202501, 1, 2, 11, 20250701, 2836.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21793, 202501, 1, 2, 11, 20250801, 3694.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21794, 202501, 1, 2, 11, 20250901, 2051.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21795, 202501, 1, 2, 11, 20251001, 1749.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21796, 202501, 1, 2, 11, 20251101, 2476.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21797, 202501, 1, 2, 11, 20251201, 3609.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21798, 202501, 1, 2, 12, 20250101, 3544.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21799, 202501, 1, 2, 12, 20250201, 3395.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21800, 202501, 1, 2, 12, 20250301, 2122.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21801, 202501, 1, 2, 12, 20250401, 3592.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21802, 202501, 1, 2, 12, 20250501, 1833.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21803, 202501, 1, 2, 12, 20250601, 2875.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21804, 202501, 1, 2, 12, 20250701, 1685.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21805, 202501, 1, 2, 12, 20250801, 2366.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21806, 202501, 1, 2, 12, 20250901, 2925.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21807, 202501, 1, 2, 12, 20251001, 1964.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21808, 202501, 1, 2, 12, 20251101, 2298.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21809, 202501, 1, 2, 12, 20251201, 3192.0000, N'Will decrease over next 12 months', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:09:31.3460000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21810, 202501, 1, 2, 13, 20250101, 2769.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21811, 202501, 1, 2, 13, 20250201, 3767.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21812, 202501, 1, 2, 13, 20250301, 3766.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21813, 202501, 1, 2, 13, 20250401, 2883.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21814, 202501, 1, 2, 13, 20250501, 1725.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21815, 202501, 1, 2, 13, 20250601, 2908.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21816, 202501, 1, 2, 13, 20250701, 2718.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21817, 202501, 1, 2, 13, 20250801, 1597.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21818, 202501, 1, 2, 13, 20250901, 1939.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21819, 202501, 1, 2, 13, 20251001, 3338.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21820, 202501, 1, 2, 13, 20251101, 1509.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21821, 202501, 1, 2, 13, 20251201, 2584.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21822, 202501, 1, 2, 15, 20250101, 2743.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21823, 202501, 1, 2, 15, 20250201, 1720.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21824, 202501, 1, 2, 15, 20250301, 3559.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21825, 202501, 1, 2, 15, 20250401, 2262.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21826, 202501, 1, 2, 15, 20250501, 2247.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21827, 202501, 1, 2, 15, 20250601, 1504.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21828, 202501, 1, 2, 15, 20250701, 3160.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21829, 202501, 1, 2, 15, 20250801, 1931.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21830, 202501, 1, 2, 15, 20250901, 2281.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21831, 202501, 1, 2, 15, 20251001, 3565.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21832, 202501, 1, 2, 15, 20251101, 3646.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21833, 202501, 1, 2, 15, 20251201, 2521.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21834, 202501, 1, 2, 16, 20250101, 1954.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21835, 202501, 1, 2, 16, 20250201, 1756.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21836, 202501, 1, 2, 16, 20250301, 2808.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21837, 202501, 1, 2, 16, 20250401, 2747.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21838, 202501, 1, 2, 16, 20250501, 1711.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21839, 202501, 1, 2, 16, 20250601, 3367.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21840, 202501, 1, 2, 16, 20250701, 3078.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21841, 202501, 1, 2, 16, 20250801, 2850.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21842, 202501, 1, 2, 16, 20250901, 3636.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21843, 202501, 1, 2, 16, 20251001, 3079.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21844, 202501, 1, 2, 16, 20251101, 2159.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21845, 202501, 1, 2, 16, 20251201, 1618.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:14.8250000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21846, 202501, 7, 1, 1, 20250101, 3416.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21847, 202501, 7, 1, 1, 20250201, 3416.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21848, 202501, 7, 1, 1, 20250301, 3045.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21849, 202501, 7, 1, 1, 20250401, 3151.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21850, 202501, 7, 1, 1, 20250501, 2706.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21851, 202501, 7, 1, 1, 20250601, 3749.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21852, 202501, 7, 1, 1, 20250701, 3584.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21853, 202501, 7, 1, 1, 20250801, 2946.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21854, 202501, 7, 1, 1, 20250901, 2442.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21855, 202501, 7, 1, 1, 20251001, 1965.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21856, 202501, 7, 1, 1, 20251101, 1479.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21857, 202501, 7, 1, 1, 20251201, 2922.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21858, 202501, 7, 1, 5, 20250101, 2973.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21859, 202501, 7, 1, 5, 20250201, 3283.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21860, 202501, 7, 1, 5, 20250301, 3598.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21861, 202501, 7, 1, 5, 20250401, 2721.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21862, 202501, 7, 1, 5, 20250501, 1696.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21863, 202501, 7, 1, 5, 20250601, 2830.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21864, 202501, 7, 1, 5, 20250701, 3102.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21865, 202501, 7, 1, 5, 20250801, 1870.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21866, 202501, 7, 1, 5, 20250901, 1619.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21867, 202501, 7, 1, 5, 20251001, 2592.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21868, 202501, 7, 1, 5, 20251101, 2098.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21869, 202501, 7, 1, 5, 20251201, 1595.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21870, 202501, 7, 1, 6, 20250101, 3551.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21871, 202501, 7, 1, 6, 20250201, 3104.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21872, 202501, 7, 1, 6, 20250301, 3537.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21873, 202501, 7, 1, 6, 20250401, 2207.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21874, 202501, 7, 1, 6, 20250501, 3447.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21875, 202501, 7, 1, 6, 20250601, 2498.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21876, 202501, 7, 1, 6, 20250701, 2734.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21877, 202501, 7, 1, 6, 20250801, 1876.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21878, 202501, 7, 1, 6, 20250901, 2321.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21879, 202501, 7, 1, 6, 20251001, 3145.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21880, 202501, 7, 1, 6, 20251101, 2740.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21881, 202501, 7, 1, 6, 20251201, 2328.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:58.1210000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21882, 202501, 7, 1, 11, 20250101, 2120.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21883, 202501, 7, 1, 11, 20250201, 1637.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21884, 202501, 7, 1, 11, 20250301, 2427.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21885, 202501, 7, 1, 11, 20250401, 1881.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21886, 202501, 7, 1, 11, 20250501, 2660.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21887, 202501, 7, 1, 11, 20250601, 3661.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21888, 202501, 7, 1, 11, 20250701, 2682.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21889, 202501, 7, 1, 11, 20250801, 1919.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21890, 202501, 7, 1, 11, 20250901, 2755.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21891, 202501, 7, 1, 11, 20251001, 3596.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21892, 202501, 7, 1, 11, 20251101, 2090.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21893, 202501, 7, 1, 11, 20251201, 2941.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21894, 202501, 7, 1, 12, 20250101, 1726.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21895, 202501, 7, 1, 12, 20250201, 1901.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21896, 202501, 7, 1, 12, 20250301, 2548.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21897, 202501, 7, 1, 12, 20250401, 3327.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21898, 202501, 7, 1, 12, 20250501, 2971.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21899, 202501, 7, 1, 12, 20250601, 2970.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21900, 202501, 7, 1, 12, 20250701, 2337.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21901, 202501, 7, 1, 12, 20250801, 2343.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21902, 202501, 7, 1, 12, 20250901, 2855.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21903, 202501, 7, 1, 12, 20251001, 2343.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21904, 202501, 7, 1, 12, 20251101, 2263.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21905, 202501, 7, 1, 12, 20251201, 3027.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21906, 202501, 7, 1, 13, 20250101, 1547.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21907, 202501, 7, 1, 13, 20250201, 3215.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21908, 202501, 7, 1, 13, 20250301, 2141.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21909, 202501, 7, 1, 13, 20250401, 3178.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21910, 202501, 7, 1, 13, 20250501, 3002.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21911, 202501, 7, 1, 13, 20250601, 1826.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21912, 202501, 7, 1, 13, 20250701, 3497.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21913, 202501, 7, 1, 13, 20250801, 1687.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21914, 202501, 7, 1, 13, 20250901, 2100.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21915, 202501, 7, 1, 13, 20251001, 3376.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21916, 202501, 7, 1, 13, 20251101, 1582.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21917, 202501, 7, 1, 13, 20251201, 3291.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21918, 202501, 7, 1, 15, 20250101, 2968.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21919, 202501, 7, 1, 15, 20250201, 3478.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21920, 202501, 7, 1, 15, 20250301, 3775.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21921, 202501, 7, 1, 15, 20250401, 2761.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21922, 202501, 7, 1, 15, 20250501, 1443.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21923, 202501, 7, 1, 15, 20250601, 3316.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21924, 202501, 7, 1, 15, 20250701, 2511.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21925, 202501, 7, 1, 15, 20250801, 1892.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21926, 202501, 7, 1, 15, 20250901, 2882.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21927, 202501, 7, 1, 15, 20251001, 3299.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21928, 202501, 7, 1, 15, 20251101, 2846.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21929, 202501, 7, 1, 15, 20251201, 2165.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21930, 202501, 7, 1, 16, 20250101, 2098.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21931, 202501, 7, 1, 16, 20250201, 3071.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21932, 202501, 7, 1, 16, 20250301, 3137.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21933, 202501, 7, 1, 16, 20250401, 2260.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21934, 202501, 7, 1, 16, 20250501, 3322.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21935, 202501, 7, 1, 16, 20250601, 2246.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21936, 202501, 7, 1, 16, 20250701, 1749.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21937, 202501, 7, 1, 16, 20250801, 2761.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21938, 202501, 7, 1, 16, 20250901, 3185.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21939, 202501, 7, 1, 16, 20251001, 2205.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21940, 202501, 7, 1, 16, 20251101, 2017.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21941, 202501, 7, 1, 16, 20251201, 2412.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:07:30.0500000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21942, 202501, 7, 3, 1, 20250101, 3147.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21943, 202501, 7, 3, 1, 20250201, 2844.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21944, 202501, 7, 3, 1, 20250301, 2151.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21945, 202501, 7, 3, 1, 20250401, 2490.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21946, 202501, 7, 3, 1, 20250501, 2271.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21947, 202501, 7, 3, 1, 20250601, 2156.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21948, 202501, 7, 3, 1, 20250701, 1760.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21949, 202501, 7, 3, 1, 20250801, 1709.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21950, 202501, 7, 3, 1, 20250901, 3404.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21951, 202501, 7, 3, 1, 20251001, 2736.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21952, 202501, 7, 3, 1, 20251101, 2240.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21953, 202501, 7, 3, 1, 20251201, 1440.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21954, 202501, 7, 3, 5, 20250101, 2062.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21955, 202501, 7, 3, 5, 20250201, 2668.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21956, 202501, 7, 3, 5, 20250301, 1657.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21957, 202501, 7, 3, 5, 20250401, 2089.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21958, 202501, 7, 3, 5, 20250501, 2769.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21959, 202501, 7, 3, 5, 20250601, 2465.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21960, 202501, 7, 3, 5, 20250701, 2220.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21961, 202501, 7, 3, 5, 20250801, 2700.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21962, 202501, 7, 3, 5, 20250901, 2601.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21963, 202501, 7, 3, 5, 20251001, 1735.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21964, 202501, 7, 3, 5, 20251101, 1809.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21965, 202501, 7, 3, 5, 20251201, 3195.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21966, 202501, 7, 3, 6, 20250101, 2723.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21967, 202501, 7, 3, 6, 20250201, 3552.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21968, 202501, 7, 3, 6, 20250301, 3488.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21969, 202501, 7, 3, 6, 20250401, 2747.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21970, 202501, 7, 3, 6, 20250501, 1911.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21971, 202501, 7, 3, 6, 20250601, 1582.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21972, 202501, 7, 3, 6, 20250701, 2997.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21973, 202501, 7, 3, 6, 20250801, 2962.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21974, 202501, 7, 3, 6, 20250901, 1691.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21975, 202501, 7, 3, 6, 20251001, 1832.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21976, 202501, 7, 3, 6, 20251101, 3257.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21977, 202501, 7, 3, 6, 20251201, 2506.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:08:48.5840000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21978, 202501, 7, 3, 11, 20250101, 2260.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21979, 202501, 7, 3, 11, 20250201, 2527.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21980, 202501, 7, 3, 11, 20250301, 3074.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21981, 202501, 7, 3, 11, 20250401, 2377.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21982, 202501, 7, 3, 11, 20250501, 1663.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21983, 202501, 7, 3, 11, 20250601, 3243.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21984, 202501, 7, 3, 11, 20250701, 2568.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21985, 202501, 7, 3, 11, 20250801, 1794.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21986, 202501, 7, 3, 11, 20250901, 2429.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21987, 202501, 7, 3, 11, 20251001, 2915.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21988, 202501, 7, 3, 11, 20251101, 2614.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21989, 202501, 7, 3, 11, 20251201, 2274.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21990, 202501, 7, 3, 12, 20250101, 3446.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21991, 202501, 7, 3, 12, 20250201, 2163.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21992, 202501, 7, 3, 12, 20250301, 2135.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2025-12-05T08:29:52.0650000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21993, 202501, 7, 3, 12, 20250401, 3003.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21994, 202501, 7, 3, 12, 20250501, 3729.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21995, 202501, 7, 3, 12, 20250601, 2361.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21996, 202501, 7, 3, 12, 20250701, 2140.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21997, 202501, 7, 3, 12, 20250801, 2277.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21998, 202501, 7, 3, 12, 20250901, 3473.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (21999, 202501, 7, 3, 12, 20251001, 3076.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22000, 202501, 7, 3, 12, 20251101, 3325.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22001, 202501, 7, 3, 12, 20251201, 3292.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22002, 202501, 7, 3, 13, 20250101, 3694.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22003, 202501, 7, 3, 13, 20250201, 1978.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22004, 202501, 7, 3, 13, 20250301, 2603.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22005, 202501, 7, 3, 13, 20250401, 3188.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22006, 202501, 7, 3, 13, 20250501, 2936.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22007, 202501, 7, 3, 13, 20250601, 3173.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22008, 202501, 7, 3, 13, 20250701, 2407.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22009, 202501, 7, 3, 13, 20250801, 2971.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22010, 202501, 7, 3, 13, 20250901, 3409.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22011, 202501, 7, 3, 13, 20251001, 2902.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22012, 202501, 7, 3, 13, 20251101, 3379.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22013, 202501, 7, 3, 13, 20251201, 1544.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22014, 202501, 7, 3, 15, 20250101, 3096.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22015, 202501, 7, 3, 15, 20250201, 3760.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22016, 202501, 7, 3, 15, 20250301, 1667.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22017, 202501, 7, 3, 15, 20250401, 3202.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22018, 202501, 7, 3, 15, 20250501, 3603.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22019, 202501, 7, 3, 15, 20250601, 2942.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22020, 202501, 7, 3, 15, 20250701, 2550.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22021, 202501, 7, 3, 15, 20250801, 3185.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22022, 202501, 7, 3, 15, 20250901, 1455.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22023, 202501, 7, 3, 15, 20251001, 2133.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22024, 202501, 7, 3, 15, 20251101, 2420.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22025, 202501, 7, 3, 15, 20251201, 3223.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22026, 202501, 7, 3, 16, 20250101, 2739.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22027, 202501, 7, 3, 16, 20250201, 2639.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22028, 202501, 7, 3, 16, 20250301, 2310.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22029, 202501, 7, 3, 16, 20250401, 1606.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22030, 202501, 7, 3, 16, 20250501, 1850.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22031, 202501, 7, 3, 16, 20250601, 1659.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22032, 202501, 7, 3, 16, 20250701, 1550.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22033, 202501, 7, 3, 16, 20250801, 3369.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22034, 202501, 7, 3, 16, 20250901, 2555.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22035, 202501, 7, 3, 16, 20251001, 1916.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22036, 202501, 7, 3, 16, 20251101, 3738.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22037, 202501, 7, 3, 16, 20251201, 1591.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:55.4760000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22038, 202501, 7, 6, 1, 20250101, 2001.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22039, 202501, 7, 6, 1, 20250201, 3553.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22040, 202501, 7, 6, 1, 20250301, 1641.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22041, 202501, 7, 6, 1, 20250401, 2553.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22042, 202501, 7, 6, 1, 20250501, 2554.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22043, 202501, 7, 6, 1, 20250601, 2199.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22044, 202501, 7, 6, 1, 20250701, 2418.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22045, 202501, 7, 6, 1, 20250801, 2095.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22046, 202501, 7, 6, 1, 20250901, 2140.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22047, 202501, 7, 6, 1, 20251001, 3569.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22048, 202501, 7, 6, 1, 20251101, 1854.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22049, 202501, 7, 6, 1, 20251201, 1899.0000, N'Reviewed JAK 251024', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:07:53.6080000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T06:56:19.6310000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22050, 202501, 7, 6, 5, 20250101, 3334.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22051, 202501, 7, 6, 5, 20250201, 3047.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22052, 202501, 7, 6, 5, 20250301, 1553.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22053, 202501, 7, 6, 5, 20250401, 2306.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22054, 202501, 7, 6, 5, 20250501, 2559.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22055, 202501, 7, 6, 5, 20250601, 3702.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22056, 202501, 7, 6, 5, 20250701, 3302.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22057, 202501, 7, 6, 5, 20250801, 1446.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22058, 202501, 7, 6, 5, 20250901, 3126.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22059, 202501, 7, 6, 5, 20251001, 2899.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22060, 202501, 7, 6, 5, 20251101, 2841.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22061, 202501, 7, 6, 5, 20251201, 1589.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:24:53.3030000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22062, 202501, 7, 6, 6, 20250101, 1457.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22063, 202501, 7, 6, 6, 20250201, 1551.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22064, 202501, 7, 6, 6, 20250301, 3636.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22065, 202501, 7, 6, 6, 20250401, 2826.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22066, 202501, 7, 6, 6, 20250501, 2358.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22067, 202501, 7, 6, 6, 20250601, 1727.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22068, 202501, 7, 6, 6, 20250701, 2945.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22069, 202501, 7, 6, 6, 20250801, 1455.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22070, 202501, 7, 6, 6, 20250901, 1904.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22071, 202501, 7, 6, 6, 20251001, 3649.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22072, 202501, 7, 6, 6, 20251101, 2094.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22073, 202501, 7, 6, 6, 20251201, 3000.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22074, 202501, 7, 6, 11, 20250101, 3622.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22075, 202501, 7, 6, 11, 20250201, 1690.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22076, 202501, 7, 6, 11, 20250301, 3012.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22077, 202501, 7, 6, 11, 20250401, 3515.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22078, 202501, 7, 6, 11, 20250501, 2949.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22079, 202501, 7, 6, 11, 20250601, 3654.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22080, 202501, 7, 6, 11, 20250701, 2591.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22081, 202501, 7, 6, 11, 20250801, 3441.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22082, 202501, 7, 6, 11, 20250901, 1681.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22083, 202501, 7, 6, 11, 20251001, 3656.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22084, 202501, 7, 6, 11, 20251101, 3156.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22085, 202501, 7, 6, 11, 20251201, 2929.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22086, 202501, 7, 6, 12, 20250101, 3779.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22087, 202501, 7, 6, 12, 20250201, 1650.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22088, 202501, 7, 6, 12, 20250301, 3498.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22089, 202501, 7, 6, 12, 20250401, 2554.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22090, 202501, 7, 6, 12, 20250501, 2225.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22091, 202501, 7, 6, 12, 20250601, 2108.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22092, 202501, 7, 6, 12, 20250701, 3720.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22093, 202501, 7, 6, 12, 20250801, 3278.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22094, 202501, 7, 6, 12, 20250901, 3689.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22095, 202501, 7, 6, 12, 20251001, 3003.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22096, 202501, 7, 6, 12, 20251101, 3310.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22097, 202501, 7, 6, 12, 20251201, 1563.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22098, 202501, 7, 6, 13, 20250101, 2455.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22099, 202501, 7, 6, 13, 20250201, 3102.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22100, 202501, 7, 6, 13, 20250301, 2292.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22101, 202501, 7, 6, 13, 20250401, 1990.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22102, 202501, 7, 6, 13, 20250501, 2199.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22103, 202501, 7, 6, 13, 20250601, 2601.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22104, 202501, 7, 6, 13, 20250701, 3391.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22105, 202501, 7, 6, 13, 20250801, 3162.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22106, 202501, 7, 6, 13, 20250901, 2526.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22107, 202501, 7, 6, 13, 20251001, 2974.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22108, 202501, 7, 6, 13, 20251101, 2564.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22109, 202501, 7, 6, 13, 20251201, 2010.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:26:45.0130000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22110, 202501, 7, 6, 15, 20250101, 3755.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22111, 202501, 7, 6, 15, 20250201, 2516.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22112, 202501, 7, 6, 15, 20250301, 2236.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22113, 202501, 7, 6, 15, 20250401, 2517.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22114, 202501, 7, 6, 15, 20250501, 3652.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22115, 202501, 7, 6, 15, 20250601, 3733.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22116, 202501, 7, 6, 15, 20250701, 2268.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22117, 202501, 7, 6, 15, 20250801, 3678.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22118, 202501, 7, 6, 15, 20250901, 1640.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22119, 202501, 7, 6, 15, 20251001, 2857.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22120, 202501, 7, 6, 15, 20251101, 2947.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22121, 202501, 7, 6, 15, 20251201, 2433.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22122, 202501, 7, 6, 16, 20250101, 2850.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22123, 202501, 7, 6, 16, 20250201, 3334.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22124, 202501, 7, 6, 16, 20250301, 3725.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22125, 202501, 7, 6, 16, 20250401, 2240.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22126, 202501, 7, 6, 16, 20250501, 2311.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22127, 202501, 7, 6, 16, 20250601, 3547.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22128, 202501, 7, 6, 16, 20250701, 1882.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22129, 202501, 7, 6, 16, 20250801, 2634.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22130, 202501, 7, 6, 16, 20250901, 1552.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22131, 202501, 7, 6, 16, 20251001, 3087.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22132, 202501, 7, 6, 16, 20251101, 2892.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (22133, 202501, 7, 6, 16, 20251201, 3535.0000, N'', N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-12-13T12:06:19.1260000' AS DateTime2), N'LAPTOP-JAK\Johannes Åkesson', CAST(N'2024-04-23T07:28:53.1210000' AS DateTime2))
GO
INSERT [dbo].[forecastData] ([ForecastDataKey], [ForecastVersionKey], [RegionKey], [CompanyKey], [AccountKey], [DateKey], [Amount], [Comment], [ModifiedBy], [ModifiedOn], [CreatedBy], [CreatedOn]) VALUES (35170, 202501, 1, 1, 1, 20250701, 1496.0000, N'', N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:08:53.0080000' AS DateTime2), N'johannes@obnextech.onmicrosoft.com', CAST(N'2025-10-24T07:08:53.0080000' AS DateTime2))
GO
SET IDENTITY_INSERT [dbo].[forecastData] OFF
GO
ALTER TABLE [dbo].[dim_Account] ADD  CONSTRAINT [DF_dim_Account_AccountGroup]  DEFAULT ((0)) FOR [AccountGroup]
GO
ALTER TABLE [dbo].[dim_Account] ADD  CONSTRAINT [DF_dim_Account_AccountGroupName]  DEFAULT ('') FOR [AccountGroupName]
GO
/****** Object:  StoredProcedure [dbo].[ApproveForecast]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Johannes Åkesson
-- Create date: 2024-10-08
-- Description:	Update the [forecast_Workflow] table and set this forecast to approved. 
-- Test execute: exec [ApproveForecast] 202401, 1,1,'UserName'
-- =============================================
CREATE PROCEDURE [dbo].[ApproveForecast]
	-- Parameters
	@Forecast_Version_Key AS INT,
	@Region_Key AS INT,
	@Company_Key AS INT, 
	@WindowsUser AS VARCHAR(MAX)
AS
BEGIN

UPDATE [dbo].[forecast_Workflow]
SET 
	[Approved] = 'True'
	,[ApprovedBy] = @WindowsUser
	,[ApprovedOn]  = GETDATE()
	,[ModifiedBy] = @WindowsUser
	,[ModifiedOn] = GETDATE()
WHERE 
	[ForecastVersionKey] = @Forecast_Version_Key AND
	[RegionKey] = @Region_Key AND
	[CompanyKey] = @Company_Key 

END


GO
/****** Object:  StoredProcedure [dbo].[CheckIfForecastCanBeSaved]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Johannes Åkesson
-- Create date: 2025-01-17
-- Description:	Checks that the forecast is not committed or approved. If it is, show a message to the user. 
-- Test execute: exec [CheckIfForecastCanBeSaved] 202401, 1,1,'UserName'
-- =============================================
CREATE PROCEDURE [dbo].[CheckIfForecastCanBeSaved]
	-- Parameters
	@Forecast_Version_Key AS INT,
	@Region_Key AS INT,
	@Company_Key AS INT
AS
BEGIN
DECLARE @IsApprovedOrCommitted AS BIT

SELECT 
	@IsApprovedOrCommitted = (CASE WHEN [Approved] = 'True' OR [Committed] =  'True' THEN 'True' ELSE 'False' END )
FROM 
	[dbo].[forecast_Workflow]
WHERE 
	[ForecastVersionKey] = @Forecast_Version_Key AND
	[RegionKey] = @Region_Key AND
	[CompanyKey] = @Company_Key 

IF @IsApprovedOrCommitted = 'True'
RAISERROR('You cannot update a forecast that has been committed or approved.',16,1);
END
GO
/****** Object:  StoredProcedure [dbo].[CommitForecast]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Johannes Åkesson
-- Create date: 2024-10-08
-- Description:	Update the [forecast_Workflow] table and set this forecast to committed. 
-- Test execute: exec [CommitForecast] 202402, 1,1,'UserName'
-- =============================================
CREATE PROCEDURE [dbo].[CommitForecast]
	-- Parameters
	@Forecast_Version_Key AS INT,	-- The Forecast v
	@Region_Key AS INT,
	@Company_Key AS INT, 
	@WindowsUser AS VARCHAR(MAX)
AS
BEGIN

UPDATE [dbo].[forecast_Workflow]
SET 
	[Committed] = 'True'
	,[CommittedOn] = GETDATE()
	,[CommittedBy] = @WindowsUser
	,[ModifiedOn] = GETDATE()
	,[ModifiedBy] = @WindowsUser
WHERE 
	[ForecastVersionKey] = @Forecast_Version_Key AND
	[RegionKey] = @Region_Key  AND
	[CompanyKey] =@Company_Key
END


GO
/****** Object:  StoredProcedure [dbo].[GetForecastStatusTexts]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Johannes Åkesson
-- Create date: 2024-10-08
-- Description:	Get the status of the selected forecast to show in the header
-- Test execute: exec [GetForecastStatusTexts] 202402, 1,2,'UserName'
-- =============================================
CREATE PROCEDURE [dbo].[GetForecastStatusTexts]
	-- Parameters
	@Forecast_Version_Key AS INT,
	@Region_Key AS INT,
	@Company_Key AS INT, 
	@WindowsUser AS VARCHAR(MAX)
AS
BEGIN

-- Get last saved parameters
DECLARE @LastSavedOn AS DATETIME2
DECLARE @LastSavedBy AS NVARCHAR(MAX)
SELECT TOP 1 @LastSavedOn = ModifiedOn, @LastSavedBy = ModifiedBy 
	FROM [dbo].[forecastData] 
WHERE 	
	[ForecastVersionKey] = @Forecast_Version_Key AND
	[RegionKey] = @Region_Key AND
	[CompanyKey] = @Company_Key
ORDER BY ModifiedOn DESC 	-- Get the latest saved row

SELECT CAST(@Forecast_Version_Key AS NVARCHAR) UNION ALL																											-- Forecast key
SELECT [ForecastName] FROM [dbo].[forecast_Version] WHERE [ForecastVersionKey] = @Forecast_Version_Key UNION ALL	-- Forecast version
SELECT [RegionName] FROM [dbo].[dim_Region] WHERE [RegionKey]=  @Region_Key UNION ALL			-- Region name
SELECT [CompanyName] FROM [dbo].[dim_Company] WHERE [CompanyKey] = @Company_Key UNION ALL				-- Company Name
SELECT 
	CASE 
		WHEN f_workflow.[Approved] = 'True' Then 'Approved by ' + f_workflow.ApprovedBy  + ' at ' + CONVERT(NVARCHAR, f_workflow.ApprovedOn, 120)
		WHEN f_workflow.[Committed] = 'True' Then 'Committed by ' + f_workflow.CommittedBy + ' at ' + CONVERT(NVARCHAR, f_workflow.CommittedOn, 120)
		WHEN f_workflow.CreatedOn = @LastSavedOn Then 'Draft based on last approved forecast' 
		ELSE 'In progress - saved by ' + @LastSavedBy + ' at ' +  CONVERT(NVARCHAR, @LastSavedOn, 120)
	END AS Text
FROM [dbo].forecast_Workflow AS f_workflow 
WHERE
	f_workflow.ForecastVersionKey =@Forecast_Version_Key AND 
	f_workflow.RegionKey = @Region_Key AND
	f_workflow.CompanyKey= @Company_Key

END


GO
/****** Object:  StoredProcedure [dbo].[GetTreeFilterItems]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Johannes Åkesson
-- Create date: 2024-10-08
-- Description:	Get the filter items from the database to build up the hierarchical tree filter
-- Test execute: exec [GetTreeFilterItems] 'LAPTOP-ATR1GRT3\JAK'
-- =============================================
CREATE PROCEDURE [dbo].[GetTreeFilterItems]
	-- Parameters
	@WindowsUser AS NVARCHAR(MAX)
AS
BEGIN

-- Get the latest yearmonth among opened forecasts to auto-expand the latest forecast version
DECLARE @LatestYearMonth INT
SELECT @LatestYearMonth = MAX(ForecastVersionKey) FROM 	[dbo].forecast_Version WHERE [Open] = 'True'

-- In a hierarchical Tree Filter the Group1, Group2.... Item

 SELECT 
	f_version.[ForecastName] AS Group1	
	--,CASE WHEN f_version.ForecastVersionKey >= @LatestYearMonth THEN 'TRUE' ELSE 'FALSE' END AS Group1Expanded	-- Auto-expand latest version
	, 'TRUE' AS Group1Expanded	
	,region.RegionName AS Group2
	--,CASE WHEN f_version.ForecastVersionKey >= @LatestYearMonth THEN 'TRUE' ELSE 'FALSE' END AS Group2Expanded-- Auto-expand latest version
	, 'TRUE' AS Group2Expanded	
	,f_version.ForecastVersionKey AS Group1_Code
	,region.RegionKey AS Group2_Code
	,company.CompanyKey AS Code
	,CASE										-- Add version status to the name of the forecast version, eg 'Forecast Feb-24 (Approved')
		WHEN f_workflow.ForecastWorkflowKey IS NULL Then company.[CompanyName] 
		WHEN f_workflow.[Approved] = 'True' Then company.[CompanyName] +  ' (Approved)'
		WHEN f_workflow.[Committed] = 'True' Then company.[CompanyName] +  ' (Committed)'
		ELSE company.[CompanyName] +  ' (In progress)'
	END AS Text
FROM 
	[dbo].forecast_Version AS f_version
CROSS JOIN 
	[dbo].[forecast_Access] AS f_access	-- Join with the access table to show all forecast 
INNER JOIN 
	[dbo].dim_Region AS region ON f_access.RegionKey = region.RegionKey
INNER JOIN 
	[dbo].dim_Company AS company ON f_access.CompanyKey= company.CompanyKey
LEFT JOIN 
	[dbo].forecast_Workflow AS f_workflow ON 
		f_workflow.ForecastVersionKey = f_version.ForecastVersionKey AND 
		f_workflow.RegionKey = f_access.RegionKey AND
		f_workflow.CompanyKey= f_access.CompanyKey
WHERE
	f_version.[Open] = 'True' AND	-- Forecast Version must be open to be seen in the Tree Filter
	(f_access.UnitManager = @WindowsUser OR f_access.InterimUnitManager = @WindowsUser  OR f_access.Approver = @WindowsUser ) -- Only get Forecasts that the user has been given access to in the forecast_Access table
ORDER BY 
	f_version.ForecastVersionKey DESC
	,region.RegionName
	,CASE 
		WHEN f_workflow.ForecastWorkflowKey IS NULL Then company.[CompanyName] 
		WHEN f_workflow.[Approved] = 'True' Then company.[CompanyName] +  ' (Approved)'
		WHEN f_workflow.[Committed] = 'True' Then company.[CompanyName] +  ' (Committed)'
		ELSE company.[CompanyName] +  ' (In progress)'
	END 

END

GO
/****** Object:  StoredProcedure [dbo].[PreLoadForecast]    Script Date: 2025-12-05 08:37:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Johannes Åkesson
-- Create date: 2024-10-08
-- Description:	Pre-loads the forecast with values from last appoved forecast. 
-- Test execute: exec [PreLoadForecast]  202402,1,1,'LAPTOP-ATR1GRT3\JAK'
-- =============================================
CREATE PROCEDURE [dbo].[PreLoadForecast]
	-- Parameters
	@SelectedForecastVersion_Key AS INT,
	@SelectedRegion_Key AS INT,
	@SelectedCompany_Key AS INT,
	@WindowsUser AS NVARCHAR(MAX)
AS
BEGIN
	
	DECLARE @CreatedOn AS DATETIME2
	SELECT  @CreatedOn = GETDATE()

	DECLARE @PreviousApprovedForecast AS INT
	
	-- Check if current forecast has any status in the Workflow table
	IF(
		(
		SELECT 
			COUNT([ForecastVersionKey]) 
		FROM  
			[dbo].[forecast_Workflow] 
		WHERE 
			[ForecastVersionKey] = @SelectedForecastVersion_Key  AND
			[RegionKey] = @SelectedRegion_Key AND
			[CompanyKey] = @SelectedCompany_Key
		) = 0 
	)
	BEGIN 
		-- The selected forecast version/region/company has no rows saved. 

		-- Look for previous approved forecast
		SELECT TOP 1
			@PreviousApprovedForecast = [ForecastVersionKey]
		FROM  
			[dbo].[forecast_Workflow] 
		WHERE 
			Approved = 'TRUE' AND 
			[RegionKey] = @SelectedRegion_Key AND
			[CompanyKey] = @SelectedCompany_Key
		ORDER BY 
			ApprovedOn DESC

			SELECT @PreviousApprovedForecast

		-- Copy the rows from the last approved forecast
		INSERT INTO 
			[dbo].[forecastData]
				(
				[ForecastVersionKey]
				,[RegionKey]
				,[CompanyKey]
				,[AccountKey]
				,DateKey
				,[Amount]
				,[Comment]
				,[ModifiedBy]
				,[ModifiedOn]
				,[CreatedBy]
				,[CreatedOn]
				)
		SELECT
				@SelectedForecastVersion_Key 
				,[RegionKey]
				,[CompanyKey]
				,[AccountKey]
				,DateKey
				,[Amount]
				,[Comment]
				,@WindowsUser
				,@CreatedOn
				,@WindowsUser
				,@CreatedOn
		FROM 
			[dbo].[forecastData] 
		WHERE 
			[ForecastVersionKey] = @PreviousApprovedForecast AND	-- Get data from previous approved forecast
			[RegionKey] = @SelectedRegion_Key  AND
			[CompanyKey] = @SelectedCompany_Key

		-- Add a new row to the workflow table
		INSERT INTO  
			[dbo].[forecast_Workflow]
				([ForecastVersionKey]
				,[RegionKey]
				,[CompanyKey]
				,[Committed]
				,[CommittedBy]
				,[CommittedOn]
				,[Approved]
				,[ApprovedBy]
				,[ApprovedOn]
		   		,[ModifiedBy]
				,[ModifiedOn]
				,[CreatedBy]
				,[CreatedOn]
				)
		VALUES (	
			@SelectedForecastVersion_Key 
			,@SelectedRegion_Key 
			,@SelectedCompany_Key
			,'false'
			,''
			,'2000-01-01'
			,'false'
			,''
			,'2000-01-01'
			,@WindowsUser
			,@CreatedOn
			,@WindowsUser
			,@CreatedOn
		)
		END
END

GO
